local function ssmTextColor()
	if GAMESTATE:IsExtraStage2() == true then
		return color("#639FFF");
	elseif GAMESTATE:IsExtraStage() == true then
		return color("#FFCF6A");
	elseif isDayTime() == 'true' then
		return color("#5A292C");
	else
		return color("#FFAA12");
	end
end;

local function ssmStrokeColor()
	if GAMESTATE:IsExtraStage2() == true then
		return color("#111E33");
	elseif GAMESTATE:IsExtraStage() == true then
		return color("#000000");
	elseif isDayTime() == 'true' then
		return color("#5A292C");
	else
		return color("#4A3612");
	end
end;

local function ssmTitleStrokeColor()
	if GAMESTATE:IsExtraStage2() == true then
		return color("#111E33");
	elseif GAMESTATE:IsExtraStage() == true then
		return color("#000000");
	elseif isDayTime() == 'true' then
		return color("#5A292C");
	else
		return color("#FF137D");
	end
end;

local function ssmTitleColor()
	if GAMESTATE:IsExtraStage2() == true then
		return color("#639FFF");
	elseif GAMESTATE:IsExtraStage() == true then
		return color("#FFCF6A");
	elseif isDayTime() == 'true' then
		return color("#5A292C");
	else
		return color("#FF674A");
	end
end;

local t = LoadFallbackB();
t[#t+1] = EXF_ScreenSelectMusic();
t[#t+1] = Def.ActorFrame{
	CodeMessageCommand = function(self, params)
		if params.Name=="ExFolder" then
			StartEXFolder(GetActiveGroupName());
		end;
	end;
};

-- t[#t+1] = Def.Quad {
        -- InitCommand=cmd(zoomto,420,90;x,SCREEN_CENTER_X+162;y,SCREEN_CENTER_Y-28;diffuse,color("#000000");fadetop,0.8;diffusealpha,0.7);
		-- OffCommand=cmd(smooth,0.7;diffusealpha,0;);
		-- CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		-- SetCommand=function(self)
            -- local song = GAMESTATE:GetCurrentSong();
			-- if song then
            -- if song:HasPreviewVid() then
				-- self:diffusealpha(0)
				-- self:smooth(0.6)
				-- self:diffusealpha(1)
			-- else
				-- self:stoptweening()
				-- self:decelerate(0.3)
				-- self:diffusealpha(0)
            -- end
			-- end
        -- end;
		-- };

-- Jacket
if not GAMESTATE:IsCourseMode() then

t[#t+1] = Def.ActorFrame {
	InitCommand=cmd(x,SCREEN_CENTER_X-150;y,SCREEN_CENTER_Y-68;);
	OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoom,0.6;rotationz,-20;);
	OnCommand=cmd(zoom,0;diffusealpha,0;decelerate,0.5;diffusealpha,1;rotationz,-10;zoom,1;);
	LoadActor("_backjacket") .. {
		InitCommand=cmd(zoom,0.37);
	};
	-- -- Preview video
	Def.Sprite {
        name="PreviewVideo";
        InitCommand=cmd(scaletoclipped,160,160;);
        CurrentSongChangedMessageCommand=function(self)
			self:playcommand("Set"):finishtweening():diffusealpha(0):zoom(0.86):decelerate(0.3):zoom(1):sleep(0.1):diffusealpha(1)
		end;
        OffCommand=cmd(smooth,0.7;diffusealpha,0;);
					SetCommand=function(self)
							local song = GAMESTATE:GetCurrentSong();
							if song then
							if song:HasPreviewVid() then
								self:visible(false)
								self:Load(song:GetPreviewVidPath())
								self:sleep(0.05)
								self:position(0)
								self:visible(true)
							else
								self:Load(nil)
								self:visible(false)
							end
							else
								self:Load(nil)
								self:visible(false)
							end
						end;
        };
	Def.Sprite {
		name="SongJacket";
		ChangedCommand=cmd(finishtweening;smooth,0.3;zoomx,0.8);
		TransitionCommand=function(self)
					local song = GAMESTATE:GetCurrentSong();
							if song then
								if song:HasPreviewVid() then
									self:finishtweening():zoom(0.86):diffusealpha(0.5):decelerate(0.3):zoom(1):diffusealpha(1):sleep(1.2):smooth(0.6):diffusealpha(0);
								else
									self:finishtweening():zoom(0.86):diffusealpha(0.5):decelerate(0.3):zoom(1):diffusealpha(1);
								end;
							end;
						end;       
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
        CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
        SetCommand=function(self)
				local song = GAMESTATE:GetCurrentSong();
						if song then
							if song:HasJacket() == true then
								self:playcommand("Changed")
								self:Load(song:GetJacketPath())
								self:playcommand("Transition")
								self:scaletoclipped(160,160)
							elseif song:HasBackground() == true then
								self:playcommand("Changed")
								self:Load(song:GetBackgroundPath())
								self:playcommand("Transition")
								self:scaletoclipped(160,160)
							elseif song:HasBanner() == true then
								self:playcommand("Changed")
								self:Load(song:GetBannerPath())
								self:playcommand("Transition")
								self:scaletoclipped(160,50)
							elseif song:HasBanner() == false then
								self:playcommand("Changed")
								self:Load(nil)
								self:scaletoclipped(160,160)
								self:playcommand("Transition")
							end
						else
							self:Load(nil)
						end
					end;
		};

	LoadActor("_jacketborder") .. {
		InitCommand=cmd(zoom,0.37;);
	};
	};
	
t[#t+1] = LoadActor("_sides") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);horizalign,left;x,SCREEN_LEFT;y,SCREEN_CENTER_Y-72;);
		OnCommand=cmd(x,SCREEN_LEFT-256;sleep,0.2;decelerate,0.5;x,SCREEN_LEFT-2-30;);
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_1 then
				(cmd(visible,true;x,SCREEN_LEFT-256;sleep,0.2;decelerate,0.5;x,SCREEN_LEFT-2-30;))(self);
			end;
		end;
		OffCommand=cmd(sleep,0.2;decelerate,0.3;x,SCREEN_LEFT-256;);
	};

t[#t+1] = LoadActor("_sides") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);zoomx,-1;horizalign,left;x,SCREEN_RIGHT;y,SCREEN_CENTER_Y-72;);
		OnCommand=cmd(x,SCREEN_RIGHT+256;sleep,0.2;decelerate,0.5;x,SCREEN_RIGHT+2+30;);
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_2 then
				(cmd(visible,true;x,SCREEN_RIGHT+256;sleep,0.2;decelerate,0.5;x,SCREEN_RIGHT+2+30))(self);
			end;
		end;
		OffCommand=cmd(sleep,0.2;decelerate,0.3;x,SCREEN_RIGHT+256;);
	};


t[#t+1] = LoadActor("_panedisplayp1") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);x,SCREEN_LEFT+115-30;y,SCREEN_CENTER_Y-40;);
		OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
		OnCommand=cmd(zoom,0.5;diffusealpha,0;sleep,0.5;decelerate,0.3;zoom,1;diffusealpha,1;);
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_1 then
				(cmd(visible,true;zoom,0.5;diffusealpha,0;sleep,0.5;decelerate,0.3;zoom,1;diffusealpha,1))(self);
			end;
		end;
	};

t[#t+1] = LoadActor("_panedisplayp2") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);horizalign,right;x,SCREEN_RIGHT-121+30;y,SCREEN_CENTER_Y-40;);
		OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
		OnCommand=cmd(zoom,0.5;diffusealpha,0;sleep,0.5;decelerate,0.3;zoom,1;diffusealpha,1;);
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_2 then
				(cmd(visible,true;zoom,0.5;diffusealpha,0;sleep,0.5;decelerate,0.3;zoom,1;diffusealpha,1))(self);
			end;
		end;
	};

if isDayTime() == 'true' then

	t[#t+1] = Def.ActorFrame {
		LoadActor("_circlebase") .. {
			InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);zoom,0.5;diffusealpha,0.5;x,SCREEN_RIGHT-120+30;y,SCREEN_CENTER_Y-110;);
			OnCommand=cmd(zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_2 then
					(cmd(visible,true;zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5))(self);
				end;
			end;
			OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
		};

		LoadActor("_circlebase") .. {
			InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);zoom,0.5;diffusealpha,0.5;x,SCREEN_LEFT+120-30;y,SCREEN_CENTER_Y-110;);
			OnCommand=cmd(zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5);
			PlayerJoinedMessageCommand=function(self,param)
				if param.Player == PLAYER_1 then
					(cmd(visible,true;zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5))(self);
				end;
			end;
			OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
		};
	};
else

t[#t+1] = Def.ActorFrame {
	LoadActor("_nightbase") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);zoom,0.5;diffusealpha,0.5;x,SCREEN_RIGHT-120+30;y,SCREEN_CENTER_Y-110;);
		OnCommand=cmd(zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5);
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_2 then
				(cmd(visible,true;zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5))(self);
			end;
		end;
		OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
	};

	LoadActor("_nightbase") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);zoom,0.5;diffusealpha,0.5;x,SCREEN_LEFT+120-30;y,SCREEN_CENTER_Y-110;);
		OnCommand=cmd(zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5);
		PlayerJoinedMessageCommand=function(self,param)
			if param.Player == PLAYER_1 then
				(cmd(visible,true;zoom,0.3;diffusealpha,0;sleep,0.5;accelerate,0.4;diffusealpha,1;zoom,0.6;smooth,0.2;zoom,0.5))(self);
			end;
		end;
		OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
	};
};
end;


t[#t+1] = LoadActor("_p1diffpod") .. {
	InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);x,SCREEN_LEFT+120-30;y,SCREEN_CENTER_Y-110;);
	OnCommand=cmd(zoom,1.1;diffusealpha,0;sleep,0.9;smooth,0.2;diffusealpha,1;zoom,1.0;);
	PlayerJoinedMessageCommand=function(self,param)
		if param.Player == PLAYER_1 then
			(cmd(visible,true;zoom,1.1;diffusealpha,0;sleep,0.9;smooth,0.2;diffusealpha,1;zoom,1.0))(self);
		end;
	end;
	OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
};

t[#t+1] = LoadActor("_p2diffpod") .. {
	InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);x,SCREEN_RIGHT-120+30;y,SCREEN_CENTER_Y-110;);
	OnCommand=cmd(zoom,1.1;diffusealpha,0;sleep,0.9;smooth,0.2;diffusealpha,1;zoom,1.0;);
	PlayerJoinedMessageCommand=function(self,param)
		if param.Player == PLAYER_2 then
			(cmd(visible,true;zoom,1.1;diffusealpha,0;sleep,0.9;smooth,0.2;diffusealpha,1;zoom,1.0))(self);
		end;
	end;
	OffCommand=cmd(decelerate,0.2;zoom,0;diffusealpha,0;);
};

-- Name That Tune!
t[#t+1] = LoadFont("_troika 24px") .. {
          InitCommand=cmd(x,SCREEN_CENTER_X-30;y,SCREEN_CENTER_Y-65;maxwidth,300;horizalign,left;zoom,0.5;visible,not GAMESTATE:IsCourseMode(););
		  OnCommand=function(self)
				self:diffuse(ssmTextColor()):strokecolor(ssmStrokeColor());
		  end;
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
          CurrentCourseChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
          ChangedLanguageDisplayMessageCommand=cmd(finishtweening;playcommand,"Set");
          SetCommand=function(self)
               local song = GAMESTATE:GetCurrentSong();
               if song then
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetGenre()); 
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end
          end;
};

t[#t+1] = LoadFont("Common normal") .. {
          InitCommand=cmd(x,SCREEN_CENTER_X-30;y,SCREEN_CENTER_Y-45;maxwidth,270;horizalign,left;visible,not GAMESTATE:IsCourseMode(););
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
		  OnCommand=function(self)
				self:diffuse(ssmTitleColor()):strokecolor(ssmTitleStrokeColor());
		  end;
          CurrentSongChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
          CurrentCourseChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
          ChangedLanguageDisplayMessageCommand=cmd(finishtweening;playcommand,"Set");
          SetCommand=function(self)
               local song = GAMESTATE:GetCurrentSong();
               if song then
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetDisplayFullTitle());
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end
          end;
};

t[#t+1] = LoadFont("Common normal") .. {
          InitCommand=cmd(x,SCREEN_CENTER_X-30;y,SCREEN_CENTER_Y-22;maxwidth,390;horizalign,left;zoom,0.6;visible,not GAMESTATE:IsCourseMode(););
		  OnCommand=function(self)
				self:diffuse(ssmTextColor()):strokecolor(ssmTitleStrokeColor());
		  end;
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          CurrentSongChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
          CurrentCourseChangedMessageCommand=cmd(finishtweening;playcommand,"Set");
          ChangedLanguageDisplayMessageCommand=cmd(finishtweening;playcommand,"Set");
          SetCommand=function(self)
               local song = GAMESTATE:GetCurrentSong();
               if song then
					self:smooth(0.2);
					self:diffusealpha(0);
					self:addx(10);
                    self:settext(song:GetDisplayArtist());
                    self:playcommand("Refresh");
					(cmd(stoptweening;addx,-6;diffusealpha,0.0;smooth,0.2;addx,6;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end
          end;
};

end

if GAMESTATE:IsCourseMode() then

-- t[#t+1] = LoadActor("_coursesides") .. {
		-- InitCommand=cmd(horizalign,center;x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-66);
		-- OnCommand=cmd(diffusealpha,0;sleep,0.2;decelerate,0.5;diffusealpha,1;);
		-- OffCommand=cmd(sleep,0.2;decelerate,0.3;zoomx,0.8;diffusealpha,0;);
	-- };

	
-- Course name	
t[#t+1] = Def.ActorFrame {
	OnCommand=cmd(diffusealpha,0;sleep,2.0;smooth,0.4;diffusealpha,1;);
	LoadFont("_dot matrix 32px") .. { 
          InitCommand=cmd(x,SCREEN_CENTER_X-220-120;y,SCREEN_CENTER_Y-136;maxwidth,450;horizalign,left;zoom,0.75;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
		  OnCommand=function(self)
				self:diffusealpha(0):queuecommand("Set"):sleep(0.4):decelerate(0.4):diffusealpha(1)
			end;
		  CurrentSongChangedMessageCommand=cmd(queuecommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(queuecommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
          SetCommand=function(self) 
               local course = GAMESTATE:GetCurrentCourse(); 
               if course then
					self:smooth(0.2)
					self:diffusealpha(0);
                    self:settext(course:GetDisplayFullTitle()); 
                    self:queuecommand("Refresh");
					(cmd(stoptweening;diffusealpha,0.0;smooth,0.2;diffusealpha,1))(self)
				else
					self:settext("");
					self:queuecommand("Refresh"); 	
               end 
			   if isDayTime() == 'true' then
					self:diffuse(color("#FFFFFF"));
					self:strokecolor(color("#000000"));
				else
					self:diffuse(color("#79F263"));
					self:strokecolor(color("#79F263"));
				end
          end; 
	};

	LoadFont("_dot matrix 32px") .. { 
          InitCommand=cmd(x,SCREEN_CENTER_X+220-110;y,SCREEN_CENTER_Y-136;maxwidth,450;horizalign,right;zoom,0.55;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;);
		  OnCommand=function(self)
				self:diffusealpha(0):queuecommand("Set"):sleep(0.4):decelerate(0.4):diffusealpha(1)
			end;
		  CurrentSongChangedMessageCommand=cmd(queuecommand,"Set"); 
          CurrentCourseChangedMessageCommand=cmd(queuecommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
          SetCommand=function(self) 
               local course = GAMESTATE:GetCurrentCourse();
               if course then
					self:smooth(0.2)
					self:diffusealpha(0);
                    self:settext(CourseTypeToLocalizedString(course:GetCourseType())); 
                    self:queuecommand("Refresh");
					(cmd(stoptweening;diffusealpha,0.0;smooth,0.2;diffusealpha,1))(self)
				else
					self:settext("");
					self:queuecommand("Refresh"); 	
               end 
			   if isDayTime() == 'true' then
					self:diffuse(color("#FFFFFF"));
					self:strokecolor(color("#000000"));
				else
					self:diffuse(color("#79F263"));
					self:strokecolor(color("#79F263"));
				end
          end; 
	};
};

t[#t+1] = StandardDecorationFromFileOptional("CourseContentsList","CourseContentsList");

	t[#t+1] = Def.ActorFrame {
		OnCommand=cmd(diffusealpha,0;sleep,2.0;smooth,0.4;diffusealpha,1;);
		LoadFont("_dot matrix 32px") .. { 
          InitCommand=cmd(x,SCREEN_CENTER_X-220-104;y,SCREEN_CENTER_Y-78;horizalign,left;diffuse,color("#FFFFFF");strokecolor,Color("Outline");zoom,1.0;); 
          CurrentCourseChangedMessageCommand=cmd(queuecommand,"Set"); 
          ChangedLanguageDisplayMessageCommand=cmd(queuecommand,"Set"); 
		  OnCommand=cmd(zoomy,0;decelerate,0.35;zoomy,1;);
		  OffCommand=cmd(decelerate,0.3;zoomy,0;);
          SetCommand=function(self) 
               local course = GAMESTATE:GetCurrentCourse(); 
               if course then
                    self:settext(course:GetEstimatedNumStages()); 
                    self:queuecommand("Refresh");
				else
					self:settext("");
					self:queuecommand("Refresh"); 	
               end
          end;
		};
		
		
		LoadFont("_dot matrix 32px") .. {
          InitCommand=cmd(zoom,0.5;x,SCREEN_CENTER_X-223-100;y,SCREEN_CENTER_Y-98;horizalign,left;diffuse,color("#FFFFFF");strokecolor,Color("Outline");settext,"# OF SONGS";); 
		  OnCommand=function(self)
				if isDayTime() == 'true' then
					self:diffuse(color("#FFFFFF"));
					self:strokecolor(color("#000000"));
				else
					self:diffuse(color("#79F263"));
					self:strokecolor(color("#79F263"));
				end
				self:diffusealpha(0):smooth(1):diffusealpha(1)
			end;
		  OffCommand=cmd(accelerate,0.2;diffusealpha,0;);
		 };
		 
		LoadFont("_dot matrix 32px") .. {
          InitCommand=cmd(zoom,0.5;x,SCREEN_CENTER_X-223-100;y,SCREEN_CENTER_Y-57;horizalign,left;diffuse,color("#FFFFFF");strokecolor,Color("Outline");settext,"LENGTH";); 
		  OnCommand=function(self)
				if isDayTime() == 'true' then
					self:diffuse(color("#FFFFFF"));
					self:strokecolor(color("#000000"));
				else
					self:diffuse(color("#79F263"));
					self:strokecolor(color("#79F263"));
				end
				self:diffusealpha(0):smooth(1):diffusealpha(1)
			end;
			OffCommand=cmd(accelerate,0.2;diffusealpha,0;);
		 };
	};
end;

t[#t+1] = LoadActor("_ssm footer") .. {
			InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_BOTTOM+50;);
			OnCommand=cmd(zoom,0.7;smooth,0.5;y,SCREEN_BOTTOM-20;);
			OffCommand=cmd(sleep,0.4;smooth,0.4;y,SCREEN_BOTTOM+50;);
	};

t[#t+1] = LoadFont("_troika 24px") .. {
          InitCommand=cmd(zoom,0.8;x,SCREEN_CENTER_X;y,SCREEN_BOTTOM-25;uppercase,true;maxwidth,SCREEN_WIDTH;diffuse,color("#FFFFFF"););
		  OnCommand=cmd(diffusealpha,0;sleep,0.5;smooth,0.3;diffusealpha,1;);
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoomy,0;);
          SortOrderChangedMessageCommand=cmd(playcommand,"Set");
          ChangedLanguageDisplayMessageCommand=cmd(playcommand,"Set");
          SetCommand=function(self)
               local sortorder = GAMESTATE:GetSortOrder();
               if sortorder then
					self:finishtweening();
					self:smooth(0.4);
					self:diffusealpha(0);
					self:addx(6);
                    self:settext(SortOrderToLocalizedString(sortorder));
                    self:playcommand("Refresh");
					(cmd(stoptweening;diffusealpha,0.0;zoomx,0;smooth,0.35;zoomx,.8;diffusealpha,1))(self)
				else
					self:settext("");
					self:playcommand("Refresh");
               end
          end;
};


t[#t+1] = StandardDecorationFromFileOptional("DifficultyList","DifficultyList");
t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. {
	SetCommand=function(self)
		local curSelection = nil;
		local length = 0.0;
		if GAMESTATE:IsCourseMode() then
			curSelection = GAMESTATE:GetCurrentCourse();
			self:playcommand("Reset");
			if curSelection then
				local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
				if trail then
					length = TrailUtil.GetTotalSeconds(trail);
				else
					length = 0.0;
				end;
			else
				length = 0.0;
			end;
		else
			curSelection = GAMESTATE:GetCurrentSong();
			self:playcommand("Reset");
			if curSelection then
				length = curSelection:MusicLengthSeconds();
				if curSelection:IsLong() then
					self:playcommand("Long");
				elseif curSelection:IsMarathon() then
					self:playcommand("Marathon");
				else
					self:playcommand("Reset");
				end
			else
				length = 0.0;
				self:playcommand("Reset");
			end;
		end;
		self:settext( SecondsToMSS(length) );
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
};

if not GAMESTATE:IsCourseMode() then
	t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
end;


t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=cmd(draworder,160;FullScreen;diffuse,color("0,0,0,1");diffusealpha,0);
		ShowPressStartForOptionsCommand=cmd(sleep,0.2;decelerate,0.5;diffusealpha,1);
	};
};


t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptionsText") .. {
	ShowPressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsShowCommand");
	ShowEnteringOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsEnterCommand");
	HidePressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsHideCommand");
};

return t